-- Uncollapse all tracks and set to specific height
-- Different heights for folder tracks vs normal tracks

-- Configuration
local folder_height = 90    -- Hauteur pour les pistes dossier (parent)
local normal_height = 140   -- Hauteur pour les pistes normales

-- Début de l'action
reaper.Undo_BeginBlock()

-- Nombre total de pistes
local track_count = reaper.CountTracks(0)

-- Parcourir toutes les pistes
for i = 0, track_count - 1 do
  local track = reaper.GetTrack(0, i)
  
  -- Vérifier si la piste est un dossier (parent track)
  local folder_depth = reaper.GetMediaTrackInfo_Value(track, "I_FOLDERDEPTH")
  
  local target_height
  if folder_depth == 1 then
    target_height = folder_height
  else
    target_height = normal_height
  end
  
  -- Déplier la piste (uncollapse)
  reaper.SetMediaTrackInfo_Value(track, "I_FOLDERCOMPACT", 0)
  
  -- Définir la hauteur de la piste
  reaper.SetMediaTrackInfo_Value(track, "I_HEIGHTOVERRIDE", target_height)
end

-- Fin de l'action
reaper.Undo_EndBlock("Uncollapse all tracks with custom heights", -1)

-- Mettre à jour l'arrangement
reaper.TrackList_AdjustWindows(false)
reaper.UpdateArrange()
